/*! For license information please see schema.js.LICENSE.txt */
!function(){"use strict";var e={"./packages/packages/libs/schema/node_modules/zod/lib/index.mjs":function(e,t,n){var r,a;n.r(t),n.d(t,{BRAND:function(){return C},DIRTY:function(){return DIRTY},EMPTY_PATH:function(){return d},INVALID:function(){return u},NEVER:function(){return ce},OK:function(){return OK},ParseStatus:function(){return ParseStatus},Schema:function(){return ZodType},ZodAny:function(){return ZodAny},ZodArray:function(){return ZodArray},ZodBigInt:function(){return ZodBigInt},ZodBoolean:function(){return ZodBoolean},ZodBranded:function(){return ZodBranded},ZodCatch:function(){return ZodCatch},ZodDate:function(){return ZodDate},ZodDefault:function(){return ZodDefault},ZodDiscriminatedUnion:function(){return ZodDiscriminatedUnion},ZodEffects:function(){return ZodEffects},ZodEnum:function(){return ZodEnum},ZodError:function(){return ZodError},ZodFirstPartyTypeKind:function(){return I},ZodFunction:function(){return ZodFunction},ZodIntersection:function(){return ZodIntersection},ZodIssueCode:function(){return i},ZodLazy:function(){return ZodLazy},ZodLiteral:function(){return ZodLiteral},ZodMap:function(){return ZodMap},ZodNaN:function(){return ZodNaN},ZodNativeEnum:function(){return ZodNativeEnum},ZodNever:function(){return ZodNever},ZodNull:function(){return ZodNull},ZodNullable:function(){return ZodNullable},ZodNumber:function(){return ZodNumber},ZodObject:function(){return ZodObject},ZodOptional:function(){return ZodOptional},ZodParsedType:function(){return s},ZodPipeline:function(){return ZodPipeline},ZodPromise:function(){return ZodPromise},ZodReadonly:function(){return ZodReadonly},ZodRecord:function(){return ZodRecord},ZodSchema:function(){return ZodType},ZodSet:function(){return ZodSet},ZodString:function(){return ZodString},ZodSymbol:function(){return ZodSymbol},ZodTransformer:function(){return ZodEffects},ZodTuple:function(){return ZodTuple},ZodType:function(){return ZodType},ZodUndefined:function(){return ZodUndefined},ZodUnion:function(){return ZodUnion},ZodUnknown:function(){return ZodUnknown},ZodVoid:function(){return ZodVoid},addIssueToContext:function(){return addIssueToContext},any:function(){return D},array:function(){return V},bigint:function(){return O},boolean:function(){return j},coerce:function(){return ue},custom:function(){return custom},date:function(){return R},datetimeRegex:function(){return datetimeRegex},default:function(){return le},defaultErrorMap:function(){return errorMap},discriminatedUnion:function(){return q},effect:function(){return ae},enum:function(){return te},function:function(){return X},getErrorMap:function(){return getErrorMap},getParsedType:function(){return getParsedType},instanceof:function(){return instanceOfType},intersection:function(){return W},isAborted:function(){return isAborted},isAsync:function(){return isAsync},isDirty:function(){return isDirty},isValid:function(){return isValid},late:function(){return P},lazy:function(){return Q},literal:function(){return ee},makeIssue:function(){return makeIssue},map:function(){return J},nan:function(){return E},nativeEnum:function(){return ne},never:function(){return U},null:function(){return L},nullable:function(){return ie},number:function(){return S},object:function(){return B},objectUtil:function(){return a},oboolean:function(){return oboolean},onumber:function(){return onumber},optional:function(){return se},ostring:function(){return ostring},pipeline:function(){return de},preprocess:function(){return oe},promise:function(){return re},quotelessJson:function(){return quotelessJson},record:function(){return Y},set:function(){return H},setErrorMap:function(){return setErrorMap},strictObject:function(){return F},string:function(){return N},symbol:function(){return A},transformer:function(){return ae},tuple:function(){return G},undefined:function(){return M},union:function(){return K},unknown:function(){return $},util:function(){return r},void:function(){return z},z:function(){return le}}),function(e){e.assertEqual=e=>e,e.assertIs=function assertIs(e){},e.assertNever=function assertNever(e){throw new Error},e.arrayToEnum=e=>{const t={};for(const n of e)t[n]=n;return t},e.getValidEnumValues=t=>{const n=e.objectKeys(t).filter(e=>"number"!=typeof t[t[e]]),r={};for(const e of n)r[e]=t[e];return e.objectValues(r)},e.objectValues=t=>e.objectKeys(t).map(function(e){return t[e]}),e.objectKeys="function"==typeof Object.keys?e=>Object.keys(e):e=>{const t=[];for(const n in e)Object.prototype.hasOwnProperty.call(e,n)&&t.push(n);return t},e.find=(e,t)=>{for(const n of e)if(t(n))return n},e.isInteger="function"==typeof Number.isInteger?e=>Number.isInteger(e):e=>"number"==typeof e&&isFinite(e)&&Math.floor(e)===e,e.joinValues=function joinValues(e,t=" | "){return e.map(e=>"string"==typeof e?`'${e}'`:e).join(t)},e.jsonStringifyReplacer=(e,t)=>"bigint"==typeof t?t.toString():t}(r||(r={})),function(e){e.mergeShapes=(e,t)=>({...e,...t})}(a||(a={}));const s=r.arrayToEnum(["string","nan","number","integer","float","boolean","date","bigint","symbol","function","undefined","null","array","object","unknown","promise","void","never","map","set"]),getParsedType=e=>{switch(typeof e){case"undefined":return s.undefined;case"string":return s.string;case"number":return isNaN(e)?s.nan:s.number;case"boolean":return s.boolean;case"function":return s.function;case"bigint":return s.bigint;case"symbol":return s.symbol;case"object":return Array.isArray(e)?s.array:null===e?s.null:e.then&&"function"==typeof e.then&&e.catch&&"function"==typeof e.catch?s.promise:"undefined"!=typeof Map&&e instanceof Map?s.map:"undefined"!=typeof Set&&e instanceof Set?s.set:"undefined"!=typeof Date&&e instanceof Date?s.date:s.object;default:return s.unknown}},i=r.arrayToEnum(["invalid_type","invalid_literal","custom","invalid_union","invalid_union_discriminator","invalid_enum_value","unrecognized_keys","invalid_arguments","invalid_return_type","invalid_date","invalid_string","too_small","too_big","invalid_intersection_types","not_multiple_of","not_finite"]),quotelessJson=e=>JSON.stringify(e,null,2).replace(/"([^"]+)":/g,"$1:");class ZodError extends Error{constructor(e){super(),this.issues=[],this.addIssue=e=>{this.issues=[...this.issues,e]},this.addIssues=(e=[])=>{this.issues=[...this.issues,...e]};const t=new.target.prototype;Object.setPrototypeOf?Object.setPrototypeOf(this,t):this.__proto__=t,this.name="ZodError",this.issues=e}get errors(){return this.issues}format(e){const t=e||function(e){return e.message},n={_errors:[]},processError=e=>{for(const r of e.issues)if("invalid_union"===r.code)r.unionErrors.map(processError);else if("invalid_return_type"===r.code)processError(r.returnTypeError);else if("invalid_arguments"===r.code)processError(r.argumentsError);else if(0===r.path.length)n._errors.push(t(r));else{let e=n,a=0;for(;a<r.path.length;){const n=r.path[a];a===r.path.length-1?(e[n]=e[n]||{_errors:[]},e[n]._errors.push(t(r))):e[n]=e[n]||{_errors:[]},e=e[n],a++}}};return processError(this),n}static assert(e){if(!(e instanceof ZodError))throw new Error(`Not a ZodError: ${e}`)}toString(){return this.message}get message(){return JSON.stringify(this.issues,r.jsonStringifyReplacer,2)}get isEmpty(){return 0===this.issues.length}flatten(e=e=>e.message){const t={},n=[];for(const r of this.issues)r.path.length>0?(t[r.path[0]]=t[r.path[0]]||[],t[r.path[0]].push(e(r))):n.push(e(r));return{formErrors:n,fieldErrors:t}}get formErrors(){return this.flatten()}}ZodError.create=e=>new ZodError(e);const errorMap=(e,t)=>{let n;switch(e.code){case i.invalid_type:n=e.received===s.undefined?"Required":`Expected ${e.expected}, received ${e.received}`;break;case i.invalid_literal:n=`Invalid literal value, expected ${JSON.stringify(e.expected,r.jsonStringifyReplacer)}`;break;case i.unrecognized_keys:n=`Unrecognized key(s) in object: ${r.joinValues(e.keys,", ")}`;break;case i.invalid_union:n="Invalid input";break;case i.invalid_union_discriminator:n=`Invalid discriminator value. Expected ${r.joinValues(e.options)}`;break;case i.invalid_enum_value:n=`Invalid enum value. Expected ${r.joinValues(e.options)}, received '${e.received}'`;break;case i.invalid_arguments:n="Invalid function arguments";break;case i.invalid_return_type:n="Invalid function return type";break;case i.invalid_date:n="Invalid date";break;case i.invalid_string:"object"==typeof e.validation?"includes"in e.validation?(n=`Invalid input: must include "${e.validation.includes}"`,"number"==typeof e.validation.position&&(n=`${n} at one or more positions greater than or equal to ${e.validation.position}`)):"startsWith"in e.validation?n=`Invalid input: must start with "${e.validation.startsWith}"`:"endsWith"in e.validation?n=`Invalid input: must end with "${e.validation.endsWith}"`:r.assertNever(e.validation):n="regex"!==e.validation?`Invalid ${e.validation}`:"Invalid";break;case i.too_small:n="array"===e.type?`Array must contain ${e.exact?"exactly":e.inclusive?"at least":"more than"} ${e.minimum} element(s)`:"string"===e.type?`String must contain ${e.exact?"exactly":e.inclusive?"at least":"over"} ${e.minimum} character(s)`:"number"===e.type?`Number must be ${e.exact?"exactly equal to ":e.inclusive?"greater than or equal to ":"greater than "}${e.minimum}`:"date"===e.type?`Date must be ${e.exact?"exactly equal to ":e.inclusive?"greater than or equal to ":"greater than "}${new Date(Number(e.minimum))}`:"Invalid input";break;case i.too_big:n="array"===e.type?`Array must contain ${e.exact?"exactly":e.inclusive?"at most":"less than"} ${e.maximum} element(s)`:"string"===e.type?`String must contain ${e.exact?"exactly":e.inclusive?"at most":"under"} ${e.maximum} character(s)`:"number"===e.type?`Number must be ${e.exact?"exactly":e.inclusive?"less than or equal to":"less than"} ${e.maximum}`:"bigint"===e.type?`BigInt must be ${e.exact?"exactly":e.inclusive?"less than or equal to":"less than"} ${e.maximum}`:"date"===e.type?`Date must be ${e.exact?"exactly":e.inclusive?"smaller than or equal to":"smaller than"} ${new Date(Number(e.maximum))}`:"Invalid input";break;case i.custom:n="Invalid input";break;case i.invalid_intersection_types:n="Intersection results could not be merged";break;case i.not_multiple_of:n=`Number must be a multiple of ${e.multipleOf}`;break;case i.not_finite:n="Number must be finite";break;default:n=t.defaultError,r.assertNever(e)}return{message:n}};let o=errorMap;function setErrorMap(e){o=e}function getErrorMap(){return o}const makeIssue=e=>{const{data:t,path:n,errorMaps:r,issueData:a}=e,s=[...n,...a.path||[]],i={...a,path:s};if(void 0!==a.message)return{...a,path:s,message:a.message};let o="";const d=r.filter(e=>!!e).slice().reverse();for(const e of d)o=e(i,{data:t,defaultError:o}).message;return{...a,path:s,message:o}},d=[];function addIssueToContext(e,t){const n=getErrorMap(),r=makeIssue({issueData:t,data:e.data,path:e.path,errorMaps:[e.common.contextualErrorMap,e.schemaErrorMap,n,n===errorMap?void 0:errorMap].filter(e=>!!e)});e.common.issues.push(r)}class ParseStatus{constructor(){this.value="valid"}dirty(){"valid"===this.value&&(this.value="dirty")}abort(){"aborted"!==this.value&&(this.value="aborted")}static mergeArray(e,t){const n=[];for(const r of t){if("aborted"===r.status)return u;"dirty"===r.status&&e.dirty(),n.push(r.value)}return{status:e.value,value:n}}static async mergeObjectAsync(e,t){const n=[];for(const e of t){const t=await e.key,r=await e.value;n.push({key:t,value:r})}return ParseStatus.mergeObjectSync(e,n)}static mergeObjectSync(e,t){const n={};for(const r of t){const{key:t,value:a}=r;if("aborted"===t.status)return u;if("aborted"===a.status)return u;"dirty"===t.status&&e.dirty(),"dirty"===a.status&&e.dirty(),"__proto__"===t.value||void 0===a.value&&!r.alwaysSet||(n[t.value]=a.value)}return{status:e.value,value:n}}}const u=Object.freeze({status:"aborted"}),DIRTY=e=>({status:"dirty",value:e}),OK=e=>({status:"valid",value:e}),isAborted=e=>"aborted"===e.status,isDirty=e=>"dirty"===e.status,isValid=e=>"valid"===e.status,isAsync=e=>"undefined"!=typeof Promise&&e instanceof Promise;function __classPrivateFieldGet(e,t,n,r){if("a"===n&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?r:"a"===n?r.call(e):r?r.value:t.get(e)}function __classPrivateFieldSet(e,t,n,r,a){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!a)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!a:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?a.call(e,n):a?a.value=n:t.set(e,n),n}var c,l,p;"function"==typeof SuppressedError&&SuppressedError,function(e){e.errToObj=e=>"string"==typeof e?{message:e}:e||{},e.toString=e=>"string"==typeof e?e:null==e?void 0:e.message}(c||(c={}));class ParseInputLazyPath{constructor(e,t,n,r){this._cachedPath=[],this.parent=e,this.data=t,this._path=n,this._key=r}get path(){return this._cachedPath.length||(this._key instanceof Array?this._cachedPath.push(...this._path,...this._key):this._cachedPath.push(...this._path,this._key)),this._cachedPath}}const handleResult=(e,t)=>{if(isValid(t))return{success:!0,data:t.value};if(!e.common.issues.length)throw new Error("Validation failed but no issues detected.");return{success:!1,get error(){if(this._error)return this._error;const t=new ZodError(e.common.issues);return this._error=t,this._error}}};function processCreateParams(e){if(!e)return{};const{errorMap:t,invalid_type_error:n,required_error:r,description:a}=e;if(t&&(n||r))throw new Error('Can\'t use "invalid_type_error" or "required_error" in conjunction with custom error map.');if(t)return{errorMap:t,description:a};return{errorMap:(t,a)=>{var s,i;const{message:o}=e;return"invalid_enum_value"===t.code?{message:null!=o?o:a.defaultError}:void 0===a.data?{message:null!==(s=null!=o?o:r)&&void 0!==s?s:a.defaultError}:"invalid_type"!==t.code?{message:a.defaultError}:{message:null!==(i=null!=o?o:n)&&void 0!==i?i:a.defaultError}},description:a}}class ZodType{constructor(e){this.spa=this.safeParseAsync,this._def=e,this.parse=this.parse.bind(this),this.safeParse=this.safeParse.bind(this),this.parseAsync=this.parseAsync.bind(this),this.safeParseAsync=this.safeParseAsync.bind(this),this.spa=this.spa.bind(this),this.refine=this.refine.bind(this),this.refinement=this.refinement.bind(this),this.superRefine=this.superRefine.bind(this),this.optional=this.optional.bind(this),this.nullable=this.nullable.bind(this),this.nullish=this.nullish.bind(this),this.array=this.array.bind(this),this.promise=this.promise.bind(this),this.or=this.or.bind(this),this.and=this.and.bind(this),this.transform=this.transform.bind(this),this.brand=this.brand.bind(this),this.default=this.default.bind(this),this.catch=this.catch.bind(this),this.describe=this.describe.bind(this),this.pipe=this.pipe.bind(this),this.readonly=this.readonly.bind(this),this.isNullable=this.isNullable.bind(this),this.isOptional=this.isOptional.bind(this)}get description(){return this._def.description}_getType(e){return getParsedType(e.data)}_getOrReturnCtx(e,t){return t||{common:e.parent.common,data:e.data,parsedType:getParsedType(e.data),schemaErrorMap:this._def.errorMap,path:e.path,parent:e.parent}}_processInputParams(e){return{status:new ParseStatus,ctx:{common:e.parent.common,data:e.data,parsedType:getParsedType(e.data),schemaErrorMap:this._def.errorMap,path:e.path,parent:e.parent}}}_parseSync(e){const t=this._parse(e);if(isAsync(t))throw new Error("Synchronous parse encountered promise.");return t}_parseAsync(e){const t=this._parse(e);return Promise.resolve(t)}parse(e,t){const n=this.safeParse(e,t);if(n.success)return n.data;throw n.error}safeParse(e,t){var n;const r={common:{issues:[],async:null!==(n=null==t?void 0:t.async)&&void 0!==n&&n,contextualErrorMap:null==t?void 0:t.errorMap},path:(null==t?void 0:t.path)||[],schemaErrorMap:this._def.errorMap,parent:null,data:e,parsedType:getParsedType(e)},a=this._parseSync({data:e,path:r.path,parent:r});return handleResult(r,a)}async parseAsync(e,t){const n=await this.safeParseAsync(e,t);if(n.success)return n.data;throw n.error}async safeParseAsync(e,t){const n={common:{issues:[],contextualErrorMap:null==t?void 0:t.errorMap,async:!0},path:(null==t?void 0:t.path)||[],schemaErrorMap:this._def.errorMap,parent:null,data:e,parsedType:getParsedType(e)},r=this._parse({data:e,path:n.path,parent:n}),a=await(isAsync(r)?r:Promise.resolve(r));return handleResult(n,a)}refine(e,t){const getIssueProperties=e=>"string"==typeof t||void 0===t?{message:t}:"function"==typeof t?t(e):t;return this._refinement((t,n)=>{const r=e(t),setError=()=>n.addIssue({code:i.custom,...getIssueProperties(t)});return"undefined"!=typeof Promise&&r instanceof Promise?r.then(e=>!!e||(setError(),!1)):!!r||(setError(),!1)})}refinement(e,t){return this._refinement((n,r)=>!!e(n)||(r.addIssue("function"==typeof t?t(n,r):t),!1))}_refinement(e){return new ZodEffects({schema:this,typeName:I.ZodEffects,effect:{type:"refinement",refinement:e}})}superRefine(e){return this._refinement(e)}optional(){return ZodOptional.create(this,this._def)}nullable(){return ZodNullable.create(this,this._def)}nullish(){return this.nullable().optional()}array(){return ZodArray.create(this,this._def)}promise(){return ZodPromise.create(this,this._def)}or(e){return ZodUnion.create([this,e],this._def)}and(e){return ZodIntersection.create(this,e,this._def)}transform(e){return new ZodEffects({...processCreateParams(this._def),schema:this,typeName:I.ZodEffects,effect:{type:"transform",transform:e}})}default(e){const t="function"==typeof e?e:()=>e;return new ZodDefault({...processCreateParams(this._def),innerType:this,defaultValue:t,typeName:I.ZodDefault})}brand(){return new ZodBranded({typeName:I.ZodBranded,type:this,...processCreateParams(this._def)})}catch(e){const t="function"==typeof e?e:()=>e;return new ZodCatch({...processCreateParams(this._def),innerType:this,catchValue:t,typeName:I.ZodCatch})}describe(e){return new(0,this.constructor)({...this._def,description:e})}pipe(e){return ZodPipeline.create(this,e)}readonly(){return ZodReadonly.create(this)}isOptional(){return this.safeParse(void 0).success}isNullable(){return this.safeParse(null).success}}const h=/^c[^\s-]{8,}$/i,m=/^[0-9a-z]+$/,f=/^[0-9A-HJKMNP-TV-Z]{26}$/,y=/^[0-9a-fA-F]{8}\b-[0-9a-fA-F]{4}\b-[0-9a-fA-F]{4}\b-[0-9a-fA-F]{4}\b-[0-9a-fA-F]{12}$/i,_=/^[a-z0-9_-]{21}$/i,v=/^[-+]?P(?!$)(?:(?:[-+]?\d+Y)|(?:[-+]?\d+[.,]\d+Y$))?(?:(?:[-+]?\d+M)|(?:[-+]?\d+[.,]\d+M$))?(?:(?:[-+]?\d+W)|(?:[-+]?\d+[.,]\d+W$))?(?:(?:[-+]?\d+D)|(?:[-+]?\d+[.,]\d+D$))?(?:T(?=[\d+-])(?:(?:[-+]?\d+H)|(?:[-+]?\d+[.,]\d+H$))?(?:(?:[-+]?\d+M)|(?:[-+]?\d+[.,]\d+M$))?(?:[-+]?\d+(?:[.,]\d+)?S)?)??$/,g=/^(?!\.)(?!.*\.\.)([A-Z0-9_'+\-\.]*)[A-Z0-9_+-]@([A-Z0-9][A-Z0-9\-]*\.)+[A-Z]{2,}$/i;let Z;const x=/^(?:(?:25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.){3}(?:25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])$/,b=/^(([a-f0-9]{1,4}:){7}|::([a-f0-9]{1,4}:){0,6}|([a-f0-9]{1,4}:){1}:([a-f0-9]{1,4}:){0,5}|([a-f0-9]{1,4}:){2}:([a-f0-9]{1,4}:){0,4}|([a-f0-9]{1,4}:){3}:([a-f0-9]{1,4}:){0,3}|([a-f0-9]{1,4}:){4}:([a-f0-9]{1,4}:){0,2}|([a-f0-9]{1,4}:){5}:([a-f0-9]{1,4}:){0,1})([a-f0-9]{1,4}|(((25[0-5])|(2[0-4][0-9])|(1[0-9]{2})|([0-9]{1,2}))\.){3}((25[0-5])|(2[0-4][0-9])|(1[0-9]{2})|([0-9]{1,2})))$/,k=/^([0-9a-zA-Z+/]{4})*(([0-9a-zA-Z+/]{2}==)|([0-9a-zA-Z+/]{3}=))?$/,T="((\\d\\d[2468][048]|\\d\\d[13579][26]|\\d\\d0[48]|[02468][048]00|[13579][26]00)-02-29|\\d{4}-((0[13578]|1[02])-(0[1-9]|[12]\\d|3[01])|(0[469]|11)-(0[1-9]|[12]\\d|30)|(02)-(0[1-9]|1\\d|2[0-8])))",w=new RegExp(`^${T}$`);function timeRegexSource(e){let t="([01]\\d|2[0-3]):[0-5]\\d:[0-5]\\d";return e.precision?t=`${t}\\.\\d{${e.precision}}`:null==e.precision&&(t=`${t}(\\.\\d+)?`),t}function timeRegex(e){return new RegExp(`^${timeRegexSource(e)}$`)}function datetimeRegex(e){let t=`${T}T${timeRegexSource(e)}`;const n=[];return n.push(e.local?"Z?":"Z"),e.offset&&n.push("([+-]\\d{2}:?\\d{2})"),t=`${t}(${n.join("|")})`,new RegExp(`^${t}$`)}function isValidIP(e,t){return!("v4"!==t&&t||!x.test(e))||!("v6"!==t&&t||!b.test(e))}class ZodString extends ZodType{_parse(e){this._def.coerce&&(e.data=String(e.data));if(this._getType(e)!==s.string){const t=this._getOrReturnCtx(e);return addIssueToContext(t,{code:i.invalid_type,expected:s.string,received:t.parsedType}),u}const t=new ParseStatus;let n;for(const a of this._def.checks)if("min"===a.kind)e.data.length<a.value&&(n=this._getOrReturnCtx(e,n),addIssueToContext(n,{code:i.too_small,minimum:a.value,type:"string",inclusive:!0,exact:!1,message:a.message}),t.dirty());else if("max"===a.kind)e.data.length>a.value&&(n=this._getOrReturnCtx(e,n),addIssueToContext(n,{code:i.too_big,maximum:a.value,type:"string",inclusive:!0,exact:!1,message:a.message}),t.dirty());else if("length"===a.kind){const r=e.data.length>a.value,s=e.data.length<a.value;(r||s)&&(n=this._getOrReturnCtx(e,n),r?addIssueToContext(n,{code:i.too_big,maximum:a.value,type:"string",inclusive:!0,exact:!0,message:a.message}):s&&addIssueToContext(n,{code:i.too_small,minimum:a.value,type:"string",inclusive:!0,exact:!0,message:a.message}),t.dirty())}else if("email"===a.kind)g.test(e.data)||(n=this._getOrReturnCtx(e,n),addIssueToContext(n,{validation:"email",code:i.invalid_string,message:a.message}),t.dirty());else if("emoji"===a.kind)Z||(Z=new RegExp("^(\\p{Extended_Pictographic}|\\p{Emoji_Component})+$","u")),Z.test(e.data)||(n=this._getOrReturnCtx(e,n),addIssueToContext(n,{validation:"emoji",code:i.invalid_string,message:a.message}),t.dirty());else if("uuid"===a.kind)y.test(e.data)||(n=this._getOrReturnCtx(e,n),addIssueToContext(n,{validation:"uuid",code:i.invalid_string,message:a.message}),t.dirty());else if("nanoid"===a.kind)_.test(e.data)||(n=this._getOrReturnCtx(e,n),addIssueToContext(n,{validation:"nanoid",code:i.invalid_string,message:a.message}),t.dirty());else if("cuid"===a.kind)h.test(e.data)||(n=this._getOrReturnCtx(e,n),addIssueToContext(n,{validation:"cuid",code:i.invalid_string,message:a.message}),t.dirty());else if("cuid2"===a.kind)m.test(e.data)||(n=this._getOrReturnCtx(e,n),addIssueToContext(n,{validation:"cuid2",code:i.invalid_string,message:a.message}),t.dirty());else if("ulid"===a.kind)f.test(e.data)||(n=this._getOrReturnCtx(e,n),addIssueToContext(n,{validation:"ulid",code:i.invalid_string,message:a.message}),t.dirty());else if("url"===a.kind)try{new URL(e.data)}catch(r){n=this._getOrReturnCtx(e,n),addIssueToContext(n,{validation:"url",code:i.invalid_string,message:a.message}),t.dirty()}else if("regex"===a.kind){a.regex.lastIndex=0;a.regex.test(e.data)||(n=this._getOrReturnCtx(e,n),addIssueToContext(n,{validation:"regex",code:i.invalid_string,message:a.message}),t.dirty())}else if("trim"===a.kind)e.data=e.data.trim();else if("includes"===a.kind)e.data.includes(a.value,a.position)||(n=this._getOrReturnCtx(e,n),addIssueToContext(n,{code:i.invalid_string,validation:{includes:a.value,position:a.position},message:a.message}),t.dirty());else if("toLowerCase"===a.kind)e.data=e.data.toLowerCase();else if("toUpperCase"===a.kind)e.data=e.data.toUpperCase();else if("startsWith"===a.kind)e.data.startsWith(a.value)||(n=this._getOrReturnCtx(e,n),addIssueToContext(n,{code:i.invalid_string,validation:{startsWith:a.value},message:a.message}),t.dirty());else if("endsWith"===a.kind)e.data.endsWith(a.value)||(n=this._getOrReturnCtx(e,n),addIssueToContext(n,{code:i.invalid_string,validation:{endsWith:a.value},message:a.message}),t.dirty());else if("datetime"===a.kind){datetimeRegex(a).test(e.data)||(n=this._getOrReturnCtx(e,n),addIssueToContext(n,{code:i.invalid_string,validation:"datetime",message:a.message}),t.dirty())}else if("date"===a.kind){w.test(e.data)||(n=this._getOrReturnCtx(e,n),addIssueToContext(n,{code:i.invalid_string,validation:"date",message:a.message}),t.dirty())}else if("time"===a.kind){timeRegex(a).test(e.data)||(n=this._getOrReturnCtx(e,n),addIssueToContext(n,{code:i.invalid_string,validation:"time",message:a.message}),t.dirty())}else"duration"===a.kind?v.test(e.data)||(n=this._getOrReturnCtx(e,n),addIssueToContext(n,{validation:"duration",code:i.invalid_string,message:a.message}),t.dirty()):"ip"===a.kind?isValidIP(e.data,a.version)||(n=this._getOrReturnCtx(e,n),addIssueToContext(n,{validation:"ip",code:i.invalid_string,message:a.message}),t.dirty()):"base64"===a.kind?k.test(e.data)||(n=this._getOrReturnCtx(e,n),addIssueToContext(n,{validation:"base64",code:i.invalid_string,message:a.message}),t.dirty()):r.assertNever(a);return{status:t.value,value:e.data}}_regex(e,t,n){return this.refinement(t=>e.test(t),{validation:t,code:i.invalid_string,...c.errToObj(n)})}_addCheck(e){return new ZodString({...this._def,checks:[...this._def.checks,e]})}email(e){return this._addCheck({kind:"email",...c.errToObj(e)})}url(e){return this._addCheck({kind:"url",...c.errToObj(e)})}emoji(e){return this._addCheck({kind:"emoji",...c.errToObj(e)})}uuid(e){return this._addCheck({kind:"uuid",...c.errToObj(e)})}nanoid(e){return this._addCheck({kind:"nanoid",...c.errToObj(e)})}cuid(e){return this._addCheck({kind:"cuid",...c.errToObj(e)})}cuid2(e){return this._addCheck({kind:"cuid2",...c.errToObj(e)})}ulid(e){return this._addCheck({kind:"ulid",...c.errToObj(e)})}base64(e){return this._addCheck({kind:"base64",...c.errToObj(e)})}ip(e){return this._addCheck({kind:"ip",...c.errToObj(e)})}datetime(e){var t,n;return"string"==typeof e?this._addCheck({kind:"datetime",precision:null,offset:!1,local:!1,message:e}):this._addCheck({kind:"datetime",precision:void 0===(null==e?void 0:e.precision)?null:null==e?void 0:e.precision,offset:null!==(t=null==e?void 0:e.offset)&&void 0!==t&&t,local:null!==(n=null==e?void 0:e.local)&&void 0!==n&&n,...c.errToObj(null==e?void 0:e.message)})}date(e){return this._addCheck({kind:"date",message:e})}time(e){return"string"==typeof e?this._addCheck({kind:"time",precision:null,message:e}):this._addCheck({kind:"time",precision:void 0===(null==e?void 0:e.precision)?null:null==e?void 0:e.precision,...c.errToObj(null==e?void 0:e.message)})}duration(e){return this._addCheck({kind:"duration",...c.errToObj(e)})}regex(e,t){return this._addCheck({kind:"regex",regex:e,...c.errToObj(t)})}includes(e,t){return this._addCheck({kind:"includes",value:e,position:null==t?void 0:t.position,...c.errToObj(null==t?void 0:t.message)})}startsWith(e,t){return this._addCheck({kind:"startsWith",value:e,...c.errToObj(t)})}endsWith(e,t){return this._addCheck({kind:"endsWith",value:e,...c.errToObj(t)})}min(e,t){return this._addCheck({kind:"min",value:e,...c.errToObj(t)})}max(e,t){return this._addCheck({kind:"max",value:e,...c.errToObj(t)})}length(e,t){return this._addCheck({kind:"length",value:e,...c.errToObj(t)})}nonempty(e){return this.min(1,c.errToObj(e))}trim(){return new ZodString({...this._def,checks:[...this._def.checks,{kind:"trim"}]})}toLowerCase(){return new ZodString({...this._def,checks:[...this._def.checks,{kind:"toLowerCase"}]})}toUpperCase(){return new ZodString({...this._def,checks:[...this._def.checks,{kind:"toUpperCase"}]})}get isDatetime(){return!!this._def.checks.find(e=>"datetime"===e.kind)}get isDate(){return!!this._def.checks.find(e=>"date"===e.kind)}get isTime(){return!!this._def.checks.find(e=>"time"===e.kind)}get isDuration(){return!!this._def.checks.find(e=>"duration"===e.kind)}get isEmail(){return!!this._def.checks.find(e=>"email"===e.kind)}get isURL(){return!!this._def.checks.find(e=>"url"===e.kind)}get isEmoji(){return!!this._def.checks.find(e=>"emoji"===e.kind)}get isUUID(){return!!this._def.checks.find(e=>"uuid"===e.kind)}get isNANOID(){return!!this._def.checks.find(e=>"nanoid"===e.kind)}get isCUID(){return!!this._def.checks.find(e=>"cuid"===e.kind)}get isCUID2(){return!!this._def.checks.find(e=>"cuid2"===e.kind)}get isULID(){return!!this._def.checks.find(e=>"ulid"===e.kind)}get isIP(){return!!this._def.checks.find(e=>"ip"===e.kind)}get isBase64(){return!!this._def.checks.find(e=>"base64"===e.kind)}get minLength(){let e=null;for(const t of this._def.checks)"min"===t.kind&&(null===e||t.value>e)&&(e=t.value);return e}get maxLength(){let e=null;for(const t of this._def.checks)"max"===t.kind&&(null===e||t.value<e)&&(e=t.value);return e}}function floatSafeRemainder(e,t){const n=(e.toString().split(".")[1]||"").length,r=(t.toString().split(".")[1]||"").length,a=n>r?n:r;return parseInt(e.toFixed(a).replace(".",""))%parseInt(t.toFixed(a).replace(".",""))/Math.pow(10,a)}ZodString.create=e=>{var t;return new ZodString({checks:[],typeName:I.ZodString,coerce:null!==(t=null==e?void 0:e.coerce)&&void 0!==t&&t,...processCreateParams(e)})};class ZodNumber extends ZodType{constructor(){super(...arguments),this.min=this.gte,this.max=this.lte,this.step=this.multipleOf}_parse(e){this._def.coerce&&(e.data=Number(e.data));if(this._getType(e)!==s.number){const t=this._getOrReturnCtx(e);return addIssueToContext(t,{code:i.invalid_type,expected:s.number,received:t.parsedType}),u}let t;const n=new ParseStatus;for(const a of this._def.checks)if("int"===a.kind)r.isInteger(e.data)||(t=this._getOrReturnCtx(e,t),addIssueToContext(t,{code:i.invalid_type,expected:"integer",received:"float",message:a.message}),n.dirty());else if("min"===a.kind){(a.inclusive?e.data<a.value:e.data<=a.value)&&(t=this._getOrReturnCtx(e,t),addIssueToContext(t,{code:i.too_small,minimum:a.value,type:"number",inclusive:a.inclusive,exact:!1,message:a.message}),n.dirty())}else if("max"===a.kind){(a.inclusive?e.data>a.value:e.data>=a.value)&&(t=this._getOrReturnCtx(e,t),addIssueToContext(t,{code:i.too_big,maximum:a.value,type:"number",inclusive:a.inclusive,exact:!1,message:a.message}),n.dirty())}else"multipleOf"===a.kind?0!==floatSafeRemainder(e.data,a.value)&&(t=this._getOrReturnCtx(e,t),addIssueToContext(t,{code:i.not_multiple_of,multipleOf:a.value,message:a.message}),n.dirty()):"finite"===a.kind?Number.isFinite(e.data)||(t=this._getOrReturnCtx(e,t),addIssueToContext(t,{code:i.not_finite,message:a.message}),n.dirty()):r.assertNever(a);return{status:n.value,value:e.data}}gte(e,t){return this.setLimit("min",e,!0,c.toString(t))}gt(e,t){return this.setLimit("min",e,!1,c.toString(t))}lte(e,t){return this.setLimit("max",e,!0,c.toString(t))}lt(e,t){return this.setLimit("max",e,!1,c.toString(t))}setLimit(e,t,n,r){return new ZodNumber({...this._def,checks:[...this._def.checks,{kind:e,value:t,inclusive:n,message:c.toString(r)}]})}_addCheck(e){return new ZodNumber({...this._def,checks:[...this._def.checks,e]})}int(e){return this._addCheck({kind:"int",message:c.toString(e)})}positive(e){return this._addCheck({kind:"min",value:0,inclusive:!1,message:c.toString(e)})}negative(e){return this._addCheck({kind:"max",value:0,inclusive:!1,message:c.toString(e)})}nonpositive(e){return this._addCheck({kind:"max",value:0,inclusive:!0,message:c.toString(e)})}nonnegative(e){return this._addCheck({kind:"min",value:0,inclusive:!0,message:c.toString(e)})}multipleOf(e,t){return this._addCheck({kind:"multipleOf",value:e,message:c.toString(t)})}finite(e){return this._addCheck({kind:"finite",message:c.toString(e)})}safe(e){return this._addCheck({kind:"min",inclusive:!0,value:Number.MIN_SAFE_INTEGER,message:c.toString(e)})._addCheck({kind:"max",inclusive:!0,value:Number.MAX_SAFE_INTEGER,message:c.toString(e)})}get minValue(){let e=null;for(const t of this._def.checks)"min"===t.kind&&(null===e||t.value>e)&&(e=t.value);return e}get maxValue(){let e=null;for(const t of this._def.checks)"max"===t.kind&&(null===e||t.value<e)&&(e=t.value);return e}get isInt(){return!!this._def.checks.find(e=>"int"===e.kind||"multipleOf"===e.kind&&r.isInteger(e.value))}get isFinite(){let e=null,t=null;for(const n of this._def.checks){if("finite"===n.kind||"int"===n.kind||"multipleOf"===n.kind)return!0;"min"===n.kind?(null===t||n.value>t)&&(t=n.value):"max"===n.kind&&(null===e||n.value<e)&&(e=n.value)}return Number.isFinite(t)&&Number.isFinite(e)}}ZodNumber.create=e=>new ZodNumber({checks:[],typeName:I.ZodNumber,coerce:(null==e?void 0:e.coerce)||!1,...processCreateParams(e)});class ZodBigInt extends ZodType{constructor(){super(...arguments),this.min=this.gte,this.max=this.lte}_parse(e){this._def.coerce&&(e.data=BigInt(e.data));if(this._getType(e)!==s.bigint){const t=this._getOrReturnCtx(e);return addIssueToContext(t,{code:i.invalid_type,expected:s.bigint,received:t.parsedType}),u}let t;const n=new ParseStatus;for(const a of this._def.checks)if("min"===a.kind){(a.inclusive?e.data<a.value:e.data<=a.value)&&(t=this._getOrReturnCtx(e,t),addIssueToContext(t,{code:i.too_small,type:"bigint",minimum:a.value,inclusive:a.inclusive,message:a.message}),n.dirty())}else if("max"===a.kind){(a.inclusive?e.data>a.value:e.data>=a.value)&&(t=this._getOrReturnCtx(e,t),addIssueToContext(t,{code:i.too_big,type:"bigint",maximum:a.value,inclusive:a.inclusive,message:a.message}),n.dirty())}else"multipleOf"===a.kind?e.data%a.value!==BigInt(0)&&(t=this._getOrReturnCtx(e,t),addIssueToContext(t,{code:i.not_multiple_of,multipleOf:a.value,message:a.message}),n.dirty()):r.assertNever(a);return{status:n.value,value:e.data}}gte(e,t){return this.setLimit("min",e,!0,c.toString(t))}gt(e,t){return this.setLimit("min",e,!1,c.toString(t))}lte(e,t){return this.setLimit("max",e,!0,c.toString(t))}lt(e,t){return this.setLimit("max",e,!1,c.toString(t))}setLimit(e,t,n,r){return new ZodBigInt({...this._def,checks:[...this._def.checks,{kind:e,value:t,inclusive:n,message:c.toString(r)}]})}_addCheck(e){return new ZodBigInt({...this._def,checks:[...this._def.checks,e]})}positive(e){return this._addCheck({kind:"min",value:BigInt(0),inclusive:!1,message:c.toString(e)})}negative(e){return this._addCheck({kind:"max",value:BigInt(0),inclusive:!1,message:c.toString(e)})}nonpositive(e){return this._addCheck({kind:"max",value:BigInt(0),inclusive:!0,message:c.toString(e)})}nonnegative(e){return this._addCheck({kind:"min",value:BigInt(0),inclusive:!0,message:c.toString(e)})}multipleOf(e,t){return this._addCheck({kind:"multipleOf",value:e,message:c.toString(t)})}get minValue(){let e=null;for(const t of this._def.checks)"min"===t.kind&&(null===e||t.value>e)&&(e=t.value);return e}get maxValue(){let e=null;for(const t of this._def.checks)"max"===t.kind&&(null===e||t.value<e)&&(e=t.value);return e}}ZodBigInt.create=e=>{var t;return new ZodBigInt({checks:[],typeName:I.ZodBigInt,coerce:null!==(t=null==e?void 0:e.coerce)&&void 0!==t&&t,...processCreateParams(e)})};class ZodBoolean extends ZodType{_parse(e){this._def.coerce&&(e.data=Boolean(e.data));if(this._getType(e)!==s.boolean){const t=this._getOrReturnCtx(e);return addIssueToContext(t,{code:i.invalid_type,expected:s.boolean,received:t.parsedType}),u}return OK(e.data)}}ZodBoolean.create=e=>new ZodBoolean({typeName:I.ZodBoolean,coerce:(null==e?void 0:e.coerce)||!1,...processCreateParams(e)});class ZodDate extends ZodType{_parse(e){this._def.coerce&&(e.data=new Date(e.data));if(this._getType(e)!==s.date){const t=this._getOrReturnCtx(e);return addIssueToContext(t,{code:i.invalid_type,expected:s.date,received:t.parsedType}),u}if(isNaN(e.data.getTime())){return addIssueToContext(this._getOrReturnCtx(e),{code:i.invalid_date}),u}const t=new ParseStatus;let n;for(const a of this._def.checks)"min"===a.kind?e.data.getTime()<a.value&&(n=this._getOrReturnCtx(e,n),addIssueToContext(n,{code:i.too_small,message:a.message,inclusive:!0,exact:!1,minimum:a.value,type:"date"}),t.dirty()):"max"===a.kind?e.data.getTime()>a.value&&(n=this._getOrReturnCtx(e,n),addIssueToContext(n,{code:i.too_big,message:a.message,inclusive:!0,exact:!1,maximum:a.value,type:"date"}),t.dirty()):r.assertNever(a);return{status:t.value,value:new Date(e.data.getTime())}}_addCheck(e){return new ZodDate({...this._def,checks:[...this._def.checks,e]})}min(e,t){return this._addCheck({kind:"min",value:e.getTime(),message:c.toString(t)})}max(e,t){return this._addCheck({kind:"max",value:e.getTime(),message:c.toString(t)})}get minDate(){let e=null;for(const t of this._def.checks)"min"===t.kind&&(null===e||t.value>e)&&(e=t.value);return null!=e?new Date(e):null}get maxDate(){let e=null;for(const t of this._def.checks)"max"===t.kind&&(null===e||t.value<e)&&(e=t.value);return null!=e?new Date(e):null}}ZodDate.create=e=>new ZodDate({checks:[],coerce:(null==e?void 0:e.coerce)||!1,typeName:I.ZodDate,...processCreateParams(e)});class ZodSymbol extends ZodType{_parse(e){if(this._getType(e)!==s.symbol){const t=this._getOrReturnCtx(e);return addIssueToContext(t,{code:i.invalid_type,expected:s.symbol,received:t.parsedType}),u}return OK(e.data)}}ZodSymbol.create=e=>new ZodSymbol({typeName:I.ZodSymbol,...processCreateParams(e)});class ZodUndefined extends ZodType{_parse(e){if(this._getType(e)!==s.undefined){const t=this._getOrReturnCtx(e);return addIssueToContext(t,{code:i.invalid_type,expected:s.undefined,received:t.parsedType}),u}return OK(e.data)}}ZodUndefined.create=e=>new ZodUndefined({typeName:I.ZodUndefined,...processCreateParams(e)});class ZodNull extends ZodType{_parse(e){if(this._getType(e)!==s.null){const t=this._getOrReturnCtx(e);return addIssueToContext(t,{code:i.invalid_type,expected:s.null,received:t.parsedType}),u}return OK(e.data)}}ZodNull.create=e=>new ZodNull({typeName:I.ZodNull,...processCreateParams(e)});class ZodAny extends ZodType{constructor(){super(...arguments),this._any=!0}_parse(e){return OK(e.data)}}ZodAny.create=e=>new ZodAny({typeName:I.ZodAny,...processCreateParams(e)});class ZodUnknown extends ZodType{constructor(){super(...arguments),this._unknown=!0}_parse(e){return OK(e.data)}}ZodUnknown.create=e=>new ZodUnknown({typeName:I.ZodUnknown,...processCreateParams(e)});class ZodNever extends ZodType{_parse(e){const t=this._getOrReturnCtx(e);return addIssueToContext(t,{code:i.invalid_type,expected:s.never,received:t.parsedType}),u}}ZodNever.create=e=>new ZodNever({typeName:I.ZodNever,...processCreateParams(e)});class ZodVoid extends ZodType{_parse(e){if(this._getType(e)!==s.undefined){const t=this._getOrReturnCtx(e);return addIssueToContext(t,{code:i.invalid_type,expected:s.void,received:t.parsedType}),u}return OK(e.data)}}ZodVoid.create=e=>new ZodVoid({typeName:I.ZodVoid,...processCreateParams(e)});class ZodArray extends ZodType{_parse(e){const{ctx:t,status:n}=this._processInputParams(e),r=this._def;if(t.parsedType!==s.array)return addIssueToContext(t,{code:i.invalid_type,expected:s.array,received:t.parsedType}),u;if(null!==r.exactLength){const e=t.data.length>r.exactLength.value,a=t.data.length<r.exactLength.value;(e||a)&&(addIssueToContext(t,{code:e?i.too_big:i.too_small,minimum:a?r.exactLength.value:void 0,maximum:e?r.exactLength.value:void 0,type:"array",inclusive:!0,exact:!0,message:r.exactLength.message}),n.dirty())}if(null!==r.minLength&&t.data.length<r.minLength.value&&(addIssueToContext(t,{code:i.too_small,minimum:r.minLength.value,type:"array",inclusive:!0,exact:!1,message:r.minLength.message}),n.dirty()),null!==r.maxLength&&t.data.length>r.maxLength.value&&(addIssueToContext(t,{code:i.too_big,maximum:r.maxLength.value,type:"array",inclusive:!0,exact:!1,message:r.maxLength.message}),n.dirty()),t.common.async)return Promise.all([...t.data].map((e,n)=>r.type._parseAsync(new ParseInputLazyPath(t,e,t.path,n)))).then(e=>ParseStatus.mergeArray(n,e));const a=[...t.data].map((e,n)=>r.type._parseSync(new ParseInputLazyPath(t,e,t.path,n)));return ParseStatus.mergeArray(n,a)}get element(){return this._def.type}min(e,t){return new ZodArray({...this._def,minLength:{value:e,message:c.toString(t)}})}max(e,t){return new ZodArray({...this._def,maxLength:{value:e,message:c.toString(t)}})}length(e,t){return new ZodArray({...this._def,exactLength:{value:e,message:c.toString(t)}})}nonempty(e){return this.min(1,e)}}function deepPartialify(e){if(e instanceof ZodObject){const t={};for(const n in e.shape){const r=e.shape[n];t[n]=ZodOptional.create(deepPartialify(r))}return new ZodObject({...e._def,shape:()=>t})}return e instanceof ZodArray?new ZodArray({...e._def,type:deepPartialify(e.element)}):e instanceof ZodOptional?ZodOptional.create(deepPartialify(e.unwrap())):e instanceof ZodNullable?ZodNullable.create(deepPartialify(e.unwrap())):e instanceof ZodTuple?ZodTuple.create(e.items.map(e=>deepPartialify(e))):e}ZodArray.create=(e,t)=>new ZodArray({type:e,minLength:null,maxLength:null,exactLength:null,typeName:I.ZodArray,...processCreateParams(t)});class ZodObject extends ZodType{constructor(){super(...arguments),this._cached=null,this.nonstrict=this.passthrough,this.augment=this.extend}_getCached(){if(null!==this._cached)return this._cached;const e=this._def.shape(),t=r.objectKeys(e);return this._cached={shape:e,keys:t}}_parse(e){if(this._getType(e)!==s.object){const t=this._getOrReturnCtx(e);return addIssueToContext(t,{code:i.invalid_type,expected:s.object,received:t.parsedType}),u}const{status:t,ctx:n}=this._processInputParams(e),{shape:r,keys:a}=this._getCached(),o=[];if(!(this._def.catchall instanceof ZodNever&&"strip"===this._def.unknownKeys))for(const e in n.data)a.includes(e)||o.push(e);const d=[];for(const e of a){const t=r[e],a=n.data[e];d.push({key:{status:"valid",value:e},value:t._parse(new ParseInputLazyPath(n,a,n.path,e)),alwaysSet:e in n.data})}if(this._def.catchall instanceof ZodNever){const e=this._def.unknownKeys;if("passthrough"===e)for(const e of o)d.push({key:{status:"valid",value:e},value:{status:"valid",value:n.data[e]}});else if("strict"===e)o.length>0&&(addIssueToContext(n,{code:i.unrecognized_keys,keys:o}),t.dirty());else if("strip"!==e)throw new Error("Internal ZodObject error: invalid unknownKeys value.")}else{const e=this._def.catchall;for(const t of o){const r=n.data[t];d.push({key:{status:"valid",value:t},value:e._parse(new ParseInputLazyPath(n,r,n.path,t)),alwaysSet:t in n.data})}}return n.common.async?Promise.resolve().then(async()=>{const e=[];for(const t of d){const n=await t.key,r=await t.value;e.push({key:n,value:r,alwaysSet:t.alwaysSet})}return e}).then(e=>ParseStatus.mergeObjectSync(t,e)):ParseStatus.mergeObjectSync(t,d)}get shape(){return this._def.shape()}strict(e){return c.errToObj,new ZodObject({...this._def,unknownKeys:"strict",...void 0!==e?{errorMap:(t,n)=>{var r,a,s,i;const o=null!==(s=null===(a=(r=this._def).errorMap)||void 0===a?void 0:a.call(r,t,n).message)&&void 0!==s?s:n.defaultError;return"unrecognized_keys"===t.code?{message:null!==(i=c.errToObj(e).message)&&void 0!==i?i:o}:{message:o}}}:{}})}strip(){return new ZodObject({...this._def,unknownKeys:"strip"})}passthrough(){return new ZodObject({...this._def,unknownKeys:"passthrough"})}extend(e){return new ZodObject({...this._def,shape:()=>({...this._def.shape(),...e})})}merge(e){return new ZodObject({unknownKeys:e._def.unknownKeys,catchall:e._def.catchall,shape:()=>({...this._def.shape(),...e._def.shape()}),typeName:I.ZodObject})}setKey(e,t){return this.augment({[e]:t})}catchall(e){return new ZodObject({...this._def,catchall:e})}pick(e){const t={};return r.objectKeys(e).forEach(n=>{e[n]&&this.shape[n]&&(t[n]=this.shape[n])}),new ZodObject({...this._def,shape:()=>t})}omit(e){const t={};return r.objectKeys(this.shape).forEach(n=>{e[n]||(t[n]=this.shape[n])}),new ZodObject({...this._def,shape:()=>t})}deepPartial(){return deepPartialify(this)}partial(e){const t={};return r.objectKeys(this.shape).forEach(n=>{const r=this.shape[n];e&&!e[n]?t[n]=r:t[n]=r.optional()}),new ZodObject({...this._def,shape:()=>t})}required(e){const t={};return r.objectKeys(this.shape).forEach(n=>{if(e&&!e[n])t[n]=this.shape[n];else{let e=this.shape[n];for(;e instanceof ZodOptional;)e=e._def.innerType;t[n]=e}}),new ZodObject({...this._def,shape:()=>t})}keyof(){return createZodEnum(r.objectKeys(this.shape))}}ZodObject.create=(e,t)=>new ZodObject({shape:()=>e,unknownKeys:"strip",catchall:ZodNever.create(),typeName:I.ZodObject,...processCreateParams(t)}),ZodObject.strictCreate=(e,t)=>new ZodObject({shape:()=>e,unknownKeys:"strict",catchall:ZodNever.create(),typeName:I.ZodObject,...processCreateParams(t)}),ZodObject.lazycreate=(e,t)=>new ZodObject({shape:e,unknownKeys:"strip",catchall:ZodNever.create(),typeName:I.ZodObject,...processCreateParams(t)});class ZodUnion extends ZodType{_parse(e){const{ctx:t}=this._processInputParams(e),n=this._def.options;if(t.common.async)return Promise.all(n.map(async e=>{const n={...t,common:{...t.common,issues:[]},parent:null};return{result:await e._parseAsync({data:t.data,path:t.path,parent:n}),ctx:n}})).then(function handleResults(e){for(const t of e)if("valid"===t.result.status)return t.result;for(const n of e)if("dirty"===n.result.status)return t.common.issues.push(...n.ctx.common.issues),n.result;const n=e.map(e=>new ZodError(e.ctx.common.issues));return addIssueToContext(t,{code:i.invalid_union,unionErrors:n}),u});{let e;const r=[];for(const a of n){const n={...t,common:{...t.common,issues:[]},parent:null},s=a._parseSync({data:t.data,path:t.path,parent:n});if("valid"===s.status)return s;"dirty"!==s.status||e||(e={result:s,ctx:n}),n.common.issues.length&&r.push(n.common.issues)}if(e)return t.common.issues.push(...e.ctx.common.issues),e.result;const a=r.map(e=>new ZodError(e));return addIssueToContext(t,{code:i.invalid_union,unionErrors:a}),u}}get options(){return this._def.options}}ZodUnion.create=(e,t)=>new ZodUnion({options:e,typeName:I.ZodUnion,...processCreateParams(t)});const getDiscriminator=e=>e instanceof ZodLazy?getDiscriminator(e.schema):e instanceof ZodEffects?getDiscriminator(e.innerType()):e instanceof ZodLiteral?[e.value]:e instanceof ZodEnum?e.options:e instanceof ZodNativeEnum?r.objectValues(e.enum):e instanceof ZodDefault?getDiscriminator(e._def.innerType):e instanceof ZodUndefined?[void 0]:e instanceof ZodNull?[null]:e instanceof ZodOptional?[void 0,...getDiscriminator(e.unwrap())]:e instanceof ZodNullable?[null,...getDiscriminator(e.unwrap())]:e instanceof ZodBranded||e instanceof ZodReadonly?getDiscriminator(e.unwrap()):e instanceof ZodCatch?getDiscriminator(e._def.innerType):[];class ZodDiscriminatedUnion extends ZodType{_parse(e){const{ctx:t}=this._processInputParams(e);if(t.parsedType!==s.object)return addIssueToContext(t,{code:i.invalid_type,expected:s.object,received:t.parsedType}),u;const n=this.discriminator,r=t.data[n],a=this.optionsMap.get(r);return a?t.common.async?a._parseAsync({data:t.data,path:t.path,parent:t}):a._parseSync({data:t.data,path:t.path,parent:t}):(addIssueToContext(t,{code:i.invalid_union_discriminator,options:Array.from(this.optionsMap.keys()),path:[n]}),u)}get discriminator(){return this._def.discriminator}get options(){return this._def.options}get optionsMap(){return this._def.optionsMap}static create(e,t,n){const r=new Map;for(const n of t){const t=getDiscriminator(n.shape[e]);if(!t.length)throw new Error(`A discriminator value for key \`${e}\` could not be extracted from all schema options`);for(const a of t){if(r.has(a))throw new Error(`Discriminator property ${String(e)} has duplicate value ${String(a)}`);r.set(a,n)}}return new ZodDiscriminatedUnion({typeName:I.ZodDiscriminatedUnion,discriminator:e,options:t,optionsMap:r,...processCreateParams(n)})}}function mergeValues(e,t){const n=getParsedType(e),a=getParsedType(t);if(e===t)return{valid:!0,data:e};if(n===s.object&&a===s.object){const n=r.objectKeys(t),a=r.objectKeys(e).filter(e=>-1!==n.indexOf(e)),s={...e,...t};for(const n of a){const r=mergeValues(e[n],t[n]);if(!r.valid)return{valid:!1};s[n]=r.data}return{valid:!0,data:s}}if(n===s.array&&a===s.array){if(e.length!==t.length)return{valid:!1};const n=[];for(let r=0;r<e.length;r++){const a=mergeValues(e[r],t[r]);if(!a.valid)return{valid:!1};n.push(a.data)}return{valid:!0,data:n}}return n===s.date&&a===s.date&&+e===+t?{valid:!0,data:e}:{valid:!1}}class ZodIntersection extends ZodType{_parse(e){const{status:t,ctx:n}=this._processInputParams(e),handleParsed=(e,r)=>{if(isAborted(e)||isAborted(r))return u;const a=mergeValues(e.value,r.value);return a.valid?((isDirty(e)||isDirty(r))&&t.dirty(),{status:t.value,value:a.data}):(addIssueToContext(n,{code:i.invalid_intersection_types}),u)};return n.common.async?Promise.all([this._def.left._parseAsync({data:n.data,path:n.path,parent:n}),this._def.right._parseAsync({data:n.data,path:n.path,parent:n})]).then(([e,t])=>handleParsed(e,t)):handleParsed(this._def.left._parseSync({data:n.data,path:n.path,parent:n}),this._def.right._parseSync({data:n.data,path:n.path,parent:n}))}}ZodIntersection.create=(e,t,n)=>new ZodIntersection({left:e,right:t,typeName:I.ZodIntersection,...processCreateParams(n)});class ZodTuple extends ZodType{_parse(e){const{status:t,ctx:n}=this._processInputParams(e);if(n.parsedType!==s.array)return addIssueToContext(n,{code:i.invalid_type,expected:s.array,received:n.parsedType}),u;if(n.data.length<this._def.items.length)return addIssueToContext(n,{code:i.too_small,minimum:this._def.items.length,inclusive:!0,exact:!1,type:"array"}),u;!this._def.rest&&n.data.length>this._def.items.length&&(addIssueToContext(n,{code:i.too_big,maximum:this._def.items.length,inclusive:!0,exact:!1,type:"array"}),t.dirty());const r=[...n.data].map((e,t)=>{const r=this._def.items[t]||this._def.rest;return r?r._parse(new ParseInputLazyPath(n,e,n.path,t)):null}).filter(e=>!!e);return n.common.async?Promise.all(r).then(e=>ParseStatus.mergeArray(t,e)):ParseStatus.mergeArray(t,r)}get items(){return this._def.items}rest(e){return new ZodTuple({...this._def,rest:e})}}ZodTuple.create=(e,t)=>{if(!Array.isArray(e))throw new Error("You must pass an array of schemas to z.tuple([ ... ])");return new ZodTuple({items:e,typeName:I.ZodTuple,rest:null,...processCreateParams(t)})};class ZodRecord extends ZodType{get keySchema(){return this._def.keyType}get valueSchema(){return this._def.valueType}_parse(e){const{status:t,ctx:n}=this._processInputParams(e);if(n.parsedType!==s.object)return addIssueToContext(n,{code:i.invalid_type,expected:s.object,received:n.parsedType}),u;const r=[],a=this._def.keyType,o=this._def.valueType;for(const e in n.data)r.push({key:a._parse(new ParseInputLazyPath(n,e,n.path,e)),value:o._parse(new ParseInputLazyPath(n,n.data[e],n.path,e)),alwaysSet:e in n.data});return n.common.async?ParseStatus.mergeObjectAsync(t,r):ParseStatus.mergeObjectSync(t,r)}get element(){return this._def.valueType}static create(e,t,n){return new ZodRecord(t instanceof ZodType?{keyType:e,valueType:t,typeName:I.ZodRecord,...processCreateParams(n)}:{keyType:ZodString.create(),valueType:e,typeName:I.ZodRecord,...processCreateParams(t)})}}class ZodMap extends ZodType{get keySchema(){return this._def.keyType}get valueSchema(){return this._def.valueType}_parse(e){const{status:t,ctx:n}=this._processInputParams(e);if(n.parsedType!==s.map)return addIssueToContext(n,{code:i.invalid_type,expected:s.map,received:n.parsedType}),u;const r=this._def.keyType,a=this._def.valueType,o=[...n.data.entries()].map(([e,t],s)=>({key:r._parse(new ParseInputLazyPath(n,e,n.path,[s,"key"])),value:a._parse(new ParseInputLazyPath(n,t,n.path,[s,"value"]))}));if(n.common.async){const e=new Map;return Promise.resolve().then(async()=>{for(const n of o){const r=await n.key,a=await n.value;if("aborted"===r.status||"aborted"===a.status)return u;"dirty"!==r.status&&"dirty"!==a.status||t.dirty(),e.set(r.value,a.value)}return{status:t.value,value:e}})}{const e=new Map;for(const n of o){const r=n.key,a=n.value;if("aborted"===r.status||"aborted"===a.status)return u;"dirty"!==r.status&&"dirty"!==a.status||t.dirty(),e.set(r.value,a.value)}return{status:t.value,value:e}}}}ZodMap.create=(e,t,n)=>new ZodMap({valueType:t,keyType:e,typeName:I.ZodMap,...processCreateParams(n)});class ZodSet extends ZodType{_parse(e){const{status:t,ctx:n}=this._processInputParams(e);if(n.parsedType!==s.set)return addIssueToContext(n,{code:i.invalid_type,expected:s.set,received:n.parsedType}),u;const r=this._def;null!==r.minSize&&n.data.size<r.minSize.value&&(addIssueToContext(n,{code:i.too_small,minimum:r.minSize.value,type:"set",inclusive:!0,exact:!1,message:r.minSize.message}),t.dirty()),null!==r.maxSize&&n.data.size>r.maxSize.value&&(addIssueToContext(n,{code:i.too_big,maximum:r.maxSize.value,type:"set",inclusive:!0,exact:!1,message:r.maxSize.message}),t.dirty());const a=this._def.valueType;function finalizeSet(e){const n=new Set;for(const r of e){if("aborted"===r.status)return u;"dirty"===r.status&&t.dirty(),n.add(r.value)}return{status:t.value,value:n}}const o=[...n.data.values()].map((e,t)=>a._parse(new ParseInputLazyPath(n,e,n.path,t)));return n.common.async?Promise.all(o).then(e=>finalizeSet(e)):finalizeSet(o)}min(e,t){return new ZodSet({...this._def,minSize:{value:e,message:c.toString(t)}})}max(e,t){return new ZodSet({...this._def,maxSize:{value:e,message:c.toString(t)}})}size(e,t){return this.min(e,t).max(e,t)}nonempty(e){return this.min(1,e)}}ZodSet.create=(e,t)=>new ZodSet({valueType:e,minSize:null,maxSize:null,typeName:I.ZodSet,...processCreateParams(t)});class ZodFunction extends ZodType{constructor(){super(...arguments),this.validate=this.implement}_parse(e){const{ctx:t}=this._processInputParams(e);if(t.parsedType!==s.function)return addIssueToContext(t,{code:i.invalid_type,expected:s.function,received:t.parsedType}),u;function makeArgsIssue(e,n){return makeIssue({data:e,path:t.path,errorMaps:[t.common.contextualErrorMap,t.schemaErrorMap,getErrorMap(),errorMap].filter(e=>!!e),issueData:{code:i.invalid_arguments,argumentsError:n}})}function makeReturnsIssue(e,n){return makeIssue({data:e,path:t.path,errorMaps:[t.common.contextualErrorMap,t.schemaErrorMap,getErrorMap(),errorMap].filter(e=>!!e),issueData:{code:i.invalid_return_type,returnTypeError:n}})}const n={errorMap:t.common.contextualErrorMap},r=t.data;if(this._def.returns instanceof ZodPromise){const e=this;return OK(async function(...t){const a=new ZodError([]),s=await e._def.args.parseAsync(t,n).catch(e=>{throw a.addIssue(makeArgsIssue(t,e)),a}),i=await Reflect.apply(r,this,s);return await e._def.returns._def.type.parseAsync(i,n).catch(e=>{throw a.addIssue(makeReturnsIssue(i,e)),a})})}{const e=this;return OK(function(...t){const a=e._def.args.safeParse(t,n);if(!a.success)throw new ZodError([makeArgsIssue(t,a.error)]);const s=Reflect.apply(r,this,a.data),i=e._def.returns.safeParse(s,n);if(!i.success)throw new ZodError([makeReturnsIssue(s,i.error)]);return i.data})}}parameters(){return this._def.args}returnType(){return this._def.returns}args(...e){return new ZodFunction({...this._def,args:ZodTuple.create(e).rest(ZodUnknown.create())})}returns(e){return new ZodFunction({...this._def,returns:e})}implement(e){return this.parse(e)}strictImplement(e){return this.parse(e)}static create(e,t,n){return new ZodFunction({args:e||ZodTuple.create([]).rest(ZodUnknown.create()),returns:t||ZodUnknown.create(),typeName:I.ZodFunction,...processCreateParams(n)})}}class ZodLazy extends ZodType{get schema(){return this._def.getter()}_parse(e){const{ctx:t}=this._processInputParams(e);return this._def.getter()._parse({data:t.data,path:t.path,parent:t})}}ZodLazy.create=(e,t)=>new ZodLazy({getter:e,typeName:I.ZodLazy,...processCreateParams(t)});class ZodLiteral extends ZodType{_parse(e){if(e.data!==this._def.value){const t=this._getOrReturnCtx(e);return addIssueToContext(t,{received:t.data,code:i.invalid_literal,expected:this._def.value}),u}return{status:"valid",value:e.data}}get value(){return this._def.value}}function createZodEnum(e,t){return new ZodEnum({values:e,typeName:I.ZodEnum,...processCreateParams(t)})}ZodLiteral.create=(e,t)=>new ZodLiteral({value:e,typeName:I.ZodLiteral,...processCreateParams(t)});class ZodEnum extends ZodType{constructor(){super(...arguments),l.set(this,void 0)}_parse(e){if("string"!=typeof e.data){const t=this._getOrReturnCtx(e),n=this._def.values;return addIssueToContext(t,{expected:r.joinValues(n),received:t.parsedType,code:i.invalid_type}),u}if(__classPrivateFieldGet(this,l,"f")||__classPrivateFieldSet(this,l,new Set(this._def.values),"f"),!__classPrivateFieldGet(this,l,"f").has(e.data)){const t=this._getOrReturnCtx(e),n=this._def.values;return addIssueToContext(t,{received:t.data,code:i.invalid_enum_value,options:n}),u}return OK(e.data)}get options(){return this._def.values}get enum(){const e={};for(const t of this._def.values)e[t]=t;return e}get Values(){const e={};for(const t of this._def.values)e[t]=t;return e}get Enum(){const e={};for(const t of this._def.values)e[t]=t;return e}extract(e,t=this._def){return ZodEnum.create(e,{...this._def,...t})}exclude(e,t=this._def){return ZodEnum.create(this.options.filter(t=>!e.includes(t)),{...this._def,...t})}}l=new WeakMap,ZodEnum.create=createZodEnum;class ZodNativeEnum extends ZodType{constructor(){super(...arguments),p.set(this,void 0)}_parse(e){const t=r.getValidEnumValues(this._def.values),n=this._getOrReturnCtx(e);if(n.parsedType!==s.string&&n.parsedType!==s.number){const e=r.objectValues(t);return addIssueToContext(n,{expected:r.joinValues(e),received:n.parsedType,code:i.invalid_type}),u}if(__classPrivateFieldGet(this,p,"f")||__classPrivateFieldSet(this,p,new Set(r.getValidEnumValues(this._def.values)),"f"),!__classPrivateFieldGet(this,p,"f").has(e.data)){const e=r.objectValues(t);return addIssueToContext(n,{received:n.data,code:i.invalid_enum_value,options:e}),u}return OK(e.data)}get enum(){return this._def.values}}p=new WeakMap,ZodNativeEnum.create=(e,t)=>new ZodNativeEnum({values:e,typeName:I.ZodNativeEnum,...processCreateParams(t)});class ZodPromise extends ZodType{unwrap(){return this._def.type}_parse(e){const{ctx:t}=this._processInputParams(e);if(t.parsedType!==s.promise&&!1===t.common.async)return addIssueToContext(t,{code:i.invalid_type,expected:s.promise,received:t.parsedType}),u;const n=t.parsedType===s.promise?t.data:Promise.resolve(t.data);return OK(n.then(e=>this._def.type.parseAsync(e,{path:t.path,errorMap:t.common.contextualErrorMap})))}}ZodPromise.create=(e,t)=>new ZodPromise({type:e,typeName:I.ZodPromise,...processCreateParams(t)});class ZodEffects extends ZodType{innerType(){return this._def.schema}sourceType(){return this._def.schema._def.typeName===I.ZodEffects?this._def.schema.sourceType():this._def.schema}_parse(e){const{status:t,ctx:n}=this._processInputParams(e),a=this._def.effect||null,s={addIssue:e=>{addIssueToContext(n,e),e.fatal?t.abort():t.dirty()},get path(){return n.path}};if(s.addIssue=s.addIssue.bind(s),"preprocess"===a.type){const e=a.transform(n.data,s);if(n.common.async)return Promise.resolve(e).then(async e=>{if("aborted"===t.value)return u;const r=await this._def.schema._parseAsync({data:e,path:n.path,parent:n});return"aborted"===r.status?u:"dirty"===r.status||"dirty"===t.value?DIRTY(r.value):r});{if("aborted"===t.value)return u;const r=this._def.schema._parseSync({data:e,path:n.path,parent:n});return"aborted"===r.status?u:"dirty"===r.status||"dirty"===t.value?DIRTY(r.value):r}}if("refinement"===a.type){const executeRefinement=e=>{const t=a.refinement(e,s);if(n.common.async)return Promise.resolve(t);if(t instanceof Promise)throw new Error("Async refinement encountered during synchronous parse operation. Use .parseAsync instead.");return e};if(!1===n.common.async){const e=this._def.schema._parseSync({data:n.data,path:n.path,parent:n});return"aborted"===e.status?u:("dirty"===e.status&&t.dirty(),executeRefinement(e.value),{status:t.value,value:e.value})}return this._def.schema._parseAsync({data:n.data,path:n.path,parent:n}).then(e=>"aborted"===e.status?u:("dirty"===e.status&&t.dirty(),executeRefinement(e.value).then(()=>({status:t.value,value:e.value}))))}if("transform"===a.type){if(!1===n.common.async){const e=this._def.schema._parseSync({data:n.data,path:n.path,parent:n});if(!isValid(e))return e;const r=a.transform(e.value,s);if(r instanceof Promise)throw new Error("Asynchronous transform encountered during synchronous parse operation. Use .parseAsync instead.");return{status:t.value,value:r}}return this._def.schema._parseAsync({data:n.data,path:n.path,parent:n}).then(e=>isValid(e)?Promise.resolve(a.transform(e.value,s)).then(e=>({status:t.value,value:e})):e)}r.assertNever(a)}}ZodEffects.create=(e,t,n)=>new ZodEffects({schema:e,typeName:I.ZodEffects,effect:t,...processCreateParams(n)}),ZodEffects.createWithPreprocess=(e,t,n)=>new ZodEffects({schema:t,effect:{type:"preprocess",transform:e},typeName:I.ZodEffects,...processCreateParams(n)});class ZodOptional extends ZodType{_parse(e){return this._getType(e)===s.undefined?OK(void 0):this._def.innerType._parse(e)}unwrap(){return this._def.innerType}}ZodOptional.create=(e,t)=>new ZodOptional({innerType:e,typeName:I.ZodOptional,...processCreateParams(t)});class ZodNullable extends ZodType{_parse(e){return this._getType(e)===s.null?OK(null):this._def.innerType._parse(e)}unwrap(){return this._def.innerType}}ZodNullable.create=(e,t)=>new ZodNullable({innerType:e,typeName:I.ZodNullable,...processCreateParams(t)});class ZodDefault extends ZodType{_parse(e){const{ctx:t}=this._processInputParams(e);let n=t.data;return t.parsedType===s.undefined&&(n=this._def.defaultValue()),this._def.innerType._parse({data:n,path:t.path,parent:t})}removeDefault(){return this._def.innerType}}ZodDefault.create=(e,t)=>new ZodDefault({innerType:e,typeName:I.ZodDefault,defaultValue:"function"==typeof t.default?t.default:()=>t.default,...processCreateParams(t)});class ZodCatch extends ZodType{_parse(e){const{ctx:t}=this._processInputParams(e),n={...t,common:{...t.common,issues:[]}},r=this._def.innerType._parse({data:n.data,path:n.path,parent:{...n}});return isAsync(r)?r.then(e=>({status:"valid",value:"valid"===e.status?e.value:this._def.catchValue({get error(){return new ZodError(n.common.issues)},input:n.data})})):{status:"valid",value:"valid"===r.status?r.value:this._def.catchValue({get error(){return new ZodError(n.common.issues)},input:n.data})}}removeCatch(){return this._def.innerType}}ZodCatch.create=(e,t)=>new ZodCatch({innerType:e,typeName:I.ZodCatch,catchValue:"function"==typeof t.catch?t.catch:()=>t.catch,...processCreateParams(t)});class ZodNaN extends ZodType{_parse(e){if(this._getType(e)!==s.nan){const t=this._getOrReturnCtx(e);return addIssueToContext(t,{code:i.invalid_type,expected:s.nan,received:t.parsedType}),u}return{status:"valid",value:e.data}}}ZodNaN.create=e=>new ZodNaN({typeName:I.ZodNaN,...processCreateParams(e)});const C=Symbol("zod_brand");class ZodBranded extends ZodType{_parse(e){const{ctx:t}=this._processInputParams(e),n=t.data;return this._def.type._parse({data:n,path:t.path,parent:t})}unwrap(){return this._def.type}}class ZodPipeline extends ZodType{_parse(e){const{status:t,ctx:n}=this._processInputParams(e);if(n.common.async){return(async()=>{const e=await this._def.in._parseAsync({data:n.data,path:n.path,parent:n});return"aborted"===e.status?u:"dirty"===e.status?(t.dirty(),DIRTY(e.value)):this._def.out._parseAsync({data:e.value,path:n.path,parent:n})})()}{const e=this._def.in._parseSync({data:n.data,path:n.path,parent:n});return"aborted"===e.status?u:"dirty"===e.status?(t.dirty(),{status:"dirty",value:e.value}):this._def.out._parseSync({data:e.value,path:n.path,parent:n})}}static create(e,t){return new ZodPipeline({in:e,out:t,typeName:I.ZodPipeline})}}class ZodReadonly extends ZodType{_parse(e){const t=this._def.innerType._parse(e),freeze=e=>(isValid(e)&&(e.value=Object.freeze(e.value)),e);return isAsync(t)?t.then(e=>freeze(e)):freeze(t)}unwrap(){return this._def.innerType}}function custom(e,t={},n){return e?ZodAny.create().superRefine((r,a)=>{var s,i;if(!e(r)){const e="function"==typeof t?t(r):"string"==typeof t?{message:t}:t,o=null===(i=null!==(s=e.fatal)&&void 0!==s?s:n)||void 0===i||i,d="string"==typeof e?{message:e}:e;a.addIssue({code:"custom",...d,fatal:o})}}):ZodAny.create()}ZodReadonly.create=(e,t)=>new ZodReadonly({innerType:e,typeName:I.ZodReadonly,...processCreateParams(t)});const P={object:ZodObject.lazycreate};var I;!function(e){e.ZodString="ZodString",e.ZodNumber="ZodNumber",e.ZodNaN="ZodNaN",e.ZodBigInt="ZodBigInt",e.ZodBoolean="ZodBoolean",e.ZodDate="ZodDate",e.ZodSymbol="ZodSymbol",e.ZodUndefined="ZodUndefined",e.ZodNull="ZodNull",e.ZodAny="ZodAny",e.ZodUnknown="ZodUnknown",e.ZodNever="ZodNever",e.ZodVoid="ZodVoid",e.ZodArray="ZodArray",e.ZodObject="ZodObject",e.ZodUnion="ZodUnion",e.ZodDiscriminatedUnion="ZodDiscriminatedUnion",e.ZodIntersection="ZodIntersection",e.ZodTuple="ZodTuple",e.ZodRecord="ZodRecord",e.ZodMap="ZodMap",e.ZodSet="ZodSet",e.ZodFunction="ZodFunction",e.ZodLazy="ZodLazy",e.ZodLiteral="ZodLiteral",e.ZodEnum="ZodEnum",e.ZodEffects="ZodEffects",e.ZodNativeEnum="ZodNativeEnum",e.ZodOptional="ZodOptional",e.ZodNullable="ZodNullable",e.ZodDefault="ZodDefault",e.ZodCatch="ZodCatch",e.ZodPromise="ZodPromise",e.ZodBranded="ZodBranded",e.ZodPipeline="ZodPipeline",e.ZodReadonly="ZodReadonly"}(I||(I={}));const instanceOfType=(e,t={message:`Input not instance of ${e.name}`})=>custom(t=>t instanceof e,t),N=ZodString.create,S=ZodNumber.create,E=ZodNaN.create,O=ZodBigInt.create,j=ZodBoolean.create,R=ZodDate.create,A=ZodSymbol.create,M=ZodUndefined.create,L=ZodNull.create,D=ZodAny.create,$=ZodUnknown.create,U=ZodNever.create,z=ZodVoid.create,V=ZodArray.create,B=ZodObject.create,F=ZodObject.strictCreate,K=ZodUnion.create,q=ZodDiscriminatedUnion.create,W=ZodIntersection.create,G=ZodTuple.create,Y=ZodRecord.create,J=ZodMap.create,H=ZodSet.create,X=ZodFunction.create,Q=ZodLazy.create,ee=ZodLiteral.create,te=ZodEnum.create,ne=ZodNativeEnum.create,re=ZodPromise.create,ae=ZodEffects.create,se=ZodOptional.create,ie=ZodNullable.create,oe=ZodEffects.createWithPreprocess,de=ZodPipeline.create,ostring=()=>N().optional(),onumber=()=>S().optional(),oboolean=()=>j().optional(),ue={string:e=>ZodString.create({...e,coerce:!0}),number:e=>ZodNumber.create({...e,coerce:!0}),boolean:e=>ZodBoolean.create({...e,coerce:!0}),bigint:e=>ZodBigInt.create({...e,coerce:!0}),date:e=>ZodDate.create({...e,coerce:!0})},ce=u;var le=Object.freeze({__proto__:null,defaultErrorMap:errorMap,setErrorMap:setErrorMap,getErrorMap:getErrorMap,makeIssue:makeIssue,EMPTY_PATH:d,addIssueToContext:addIssueToContext,ParseStatus:ParseStatus,INVALID:u,DIRTY:DIRTY,OK:OK,isAborted:isAborted,isDirty:isDirty,isValid:isValid,isAsync:isAsync,get util(){return r},get objectUtil(){return a},ZodParsedType:s,getParsedType:getParsedType,ZodType:ZodType,datetimeRegex:datetimeRegex,ZodString:ZodString,ZodNumber:ZodNumber,ZodBigInt:ZodBigInt,ZodBoolean:ZodBoolean,ZodDate:ZodDate,ZodSymbol:ZodSymbol,ZodUndefined:ZodUndefined,ZodNull:ZodNull,ZodAny:ZodAny,ZodUnknown:ZodUnknown,ZodNever:ZodNever,ZodVoid:ZodVoid,ZodArray:ZodArray,ZodObject:ZodObject,ZodUnion:ZodUnion,ZodDiscriminatedUnion:ZodDiscriminatedUnion,ZodIntersection:ZodIntersection,ZodTuple:ZodTuple,ZodRecord:ZodRecord,ZodMap:ZodMap,ZodSet:ZodSet,ZodFunction:ZodFunction,ZodLazy:ZodLazy,ZodLiteral:ZodLiteral,ZodEnum:ZodEnum,ZodNativeEnum:ZodNativeEnum,ZodPromise:ZodPromise,ZodEffects:ZodEffects,ZodTransformer:ZodEffects,ZodOptional:ZodOptional,ZodNullable:ZodNullable,ZodDefault:ZodDefault,ZodCatch:ZodCatch,ZodNaN:ZodNaN,BRAND:C,ZodBranded:ZodBranded,ZodPipeline:ZodPipeline,ZodReadonly:ZodReadonly,custom:custom,Schema:ZodType,ZodSchema:ZodType,late:P,get ZodFirstPartyTypeKind(){return I},coerce:ue,any:D,array:V,bigint:O,boolean:j,date:R,discriminatedUnion:q,effect:ae,enum:te,function:X,instanceof:instanceOfType,intersection:W,lazy:Q,literal:ee,map:J,nan:E,nativeEnum:ne,never:U,null:L,nullable:ie,number:S,object:B,oboolean:oboolean,onumber:onumber,optional:se,ostring:ostring,pipeline:de,preprocess:oe,promise:re,record:Y,set:H,strictObject:F,string:N,symbol:A,transformer:ae,tuple:G,undefined:M,union:K,unknown:$,void:z,NEVER:ce,ZodIssueCode:i,quotelessJson:quotelessJson,ZodError:ZodError})}},t={};function __webpack_require__(n){var r=t[n];if(void 0!==r)return r.exports;var a=t[n]={exports:{}};return e[n](a,a.exports,__webpack_require__),a.exports}__webpack_require__.d=function(e,t){for(var n in t)__webpack_require__.o(t,n)&&!__webpack_require__.o(e,n)&&Object.defineProperty(e,n,{enumerable:!0,get:t[n]})},__webpack_require__.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},__webpack_require__.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})};var n={};!function(){__webpack_require__.r(n),__webpack_require__.d(n,{z:function(){return e.z}});var e=__webpack_require__("./packages/packages/libs/schema/node_modules/zod/lib/index.mjs")}(),(window.elementorV2=window.elementorV2||{}).schema=n}(),window.elementorV2.schema?.init?.();
//# sourceMappingURL=schema.js.map